############### ###############
## F_H1_A_Intensity_of_engagement
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

ggplot(CBO_groups_final,
       aes(x = A_Intensity_of_engagement)) + 
  geom_histogram(binwidth = 0.1) + 
  labs(
    x = "Intensity of engagement in municipal governance: Z-score average index", 
    y = "Number of CBOs"
  ) +
  theme_minimal() +
  theme(text = element_text(size=11, family="Times"))  +
  theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))

ggsave(width = 7, height = 3, filename = paste0(path, "H1_", "A_Intensity_of_engagement.png"), device = png,  dpi=200)